unit ucAdmins;

interface

uses SysUtils, System.Text, System.Data, System.Drawing, System.Web, System.Web.UI,
     System.Web.UI.WebControls, System.Web.UI.HtmlControls, SmartDataGrid;

type
    /// <summary>
    /// Summary description for WebUserControl1.
    /// </summary>
  TucAdmins = class(System.Web.UI.UserControl)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure DG_CancelCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure DG_EditCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure DG_UpdateCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure DG_DeleteCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure AddAdminButton_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    DG: SmartDataGrid.TSmartDataGrid;
    ErrorMessage: System.Web.UI.WebControls.Label;
    Name: System.Web.UI.WebControls.TextBox;
    RequiredFieldValidator1: System.Web.UI.WebControls.RequiredFieldValidator;
    Email: System.Web.UI.WebControls.TextBox;
    RegularExpressionValidator1: System.Web.UI.WebControls.RegularExpressionValidator;
    RequiredFieldValidator2: System.Web.UI.WebControls.RequiredFieldValidator;
    Password: System.Web.UI.WebControls.TextBox;
    RequiredFieldValidator3: System.Web.UI.WebControls.RequiredFieldValidator;
    dlSubMenu: System.Web.UI.WebControls.DataList;
    AddAdminButton: System.Web.UI.WebControls.Button;
    procedure OnInit(e: System.EventArgs); override;
  private
    procedure FixAdminAdding(const CanAdd : boolean);
  public
    { Public Declarations }
  end;

implementation

uses Helper, AdminDB;

procedure TucAdmins.Page_Load(sender: System.Object; e: System.EventArgs);
var
  selSQL : StringBuilder;
begin

	selSQL := StringBuilder.Create;
  selSQL.Append('SELECT * FROM Customers WHERE IsAdmin = 1');


  DG.AutoGenerateColumns:=False;
  DG.PageSize:=15;
  DG.AllowPaging := True;

  DG.SelectSQL := selSQL.ToString;
  DG.DeleteSQL := 'DELETE FROM Customers WHERE CustomerID = ';
  
  DG.ErrorLabel := ErrorMessage;
  DG.DataKeyField := 'CustomerID';
  

  if not page.IsPostBack then DG.BindData;
end;

procedure TucAdmins.OnInit(e: System.EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TucAdmins.InitializeComponent;
begin
  Include(Self.AddAdminButton.Click, Self.AddAdminButton_Click);
  Include(Self.DG.EditCommand, Self.DG_EditCommand);
  Include(Self.DG.CancelCommand, Self.DG_CancelCommand);
  Include(Self.DG.UpdateCommand, Self.DG_UpdateCommand);
  Include(Self.DG.DeleteCommand, Self.DG_DeleteCommand);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}


procedure TucAdmins.FixAdminAdding(const CanAdd: boolean);
begin
  RequiredFieldValidator1.Enabled := CanAdd;
  RequiredFieldValidator2.Enabled := CanAdd;
  RequiredFieldValidator3.Enabled := CanAdd;
  RegularExpressionValidator1.Enabled := CanAdd;
  AddAdminButton.Enabled := CanAdd;

end;

procedure TucAdmins.AddAdminButton_Click(sender: System.Object; e: System.EventArgs);
var
  AdminDB : TAdminDB;
begin
  	// Only attempt a login if all form fields on the page are valid
	If NOT Page.IsValid Then Exit;

  AdminDB := TAdminDB.Create;
  if AdminDB.AddAdmin(Server.HtmlEncode(Name.Text), Email.Text, Password.Text) then
  begin
    ErrorMessage.Text := 'Administrator added!';
    DG.BindData;

    Name.Text := '';
    Email.Text := '';
  end
  else
    ErrorMessage.Text := 'That email address is already registered.';


end;

procedure TucAdmins.DG_DeleteCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
begin
  if THelper.MasterAdminID.ToString = DG.DataKeys[e.Item.ItemIndex].ToString then
  begin
    DG.DeleteSQL := '';
    ErrorMessage.Text := 'Cannot delete MASTER administrator!';
  end;

end;

procedure TucAdmins.DG_UpdateCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  custid, name, email, pass : string;
begin
  custid := DG.DataKeys[e.Item.ItemIndex].ToString();
  name := TextBox(e.Item.FindControl('name')).Text;
  email := TextBox(e.Item.FindControl('email')).Text;
  pass := TextBox(e.Item.FindControl('pass')).Text;

  if THelper.MasterAdminID.ToString <> custID then
    DG.UpdateSQL := 'UPDATE Customers SET FullName = ' + QuotedStr(Server.HtmlEncode(name)) +', EmailAddress = '+QuotedStr(email)+', Pass = '+QuotedStr(pass)+' Where IsAdmin = 1 AND CustomerID = ' + custid
  else
  begin
    DG.UpdateSQL := '';
    ErrorMessage.Text := 'Cannot update "Master" administrator!';
  end;

  FixAdminAdding(True);
end;

procedure TucAdmins.DG_EditCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
begin
  FixAdminAdding(False);
end;

procedure TucAdmins.DG_CancelCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
begin
  FixAdminAdding(True);
end;

end.
